use AdventureWorks
GO
IF EXISTS (SELECT * FROM sys.service_broker_endpoints WHERE name = 'EP_SSB')
	DROP ENDPOINT EP_SSB
GO
IF EXISTS (SELECT * FROM sys.routes WHERE name = 'tcp://codecamp/AW/route')
	DROP ROUTE [tcp://codecamp/AW/route]
GO
IF EXISTS (SELECT * FROM sys.services WHERE name = 'tcp://codecamp/AW/sample_send_service')
	DROP SERVICE [tcp://codecamp/AW/sample_send_service]
GO
IF EXISTS (SELECT * FROM sys.services WHERE name = 'tcp://codecamp/AW/sample_receive_service')
	DROP SERVICE [tcp://codecamp/AW/sample_receive_service]
GO
IF EXISTS (SELECT * FROM sys.service_queues WHERE name = 'tcp://codecamp/AW/sample_sender')
	DROP QUEUE [tcp://codecamp/AW/sample_sender]
GO
IF EXISTS (SELECT * FROM sys.service_queues WHERE name = 'tcp://codecamp/AW/sample_receiver')
	DROP QUEUE [tcp://codecamp/AW/sample_receiver]
GO
IF EXISTS (SELECT * FROM sys.service_contracts WHERE name = 'tcp://codecamp/AW/sample_contract')
	DROP CONTRACT [tcp://codecamp/AW/sample_contract]
GO
IF EXISTS (SELECT * FROM sys.service_message_types WHERE name = 'tcp://codecamp/AW/sample_messagetype')
	DROP MESSAGE TYPE [tcp://codecamp/AW/sample_messagetype]
GO
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'usp_SendMessage')
	DROP PROCEDURE dbo.usp_SendMessage
GO
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'usp_ReceiveMessage')
	DROP PROCEDURE dbo.usp_ReceiveMessage
GO
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'usp_ProcessAck')
	DROP PROCEDURE dbo.usp_ProcessAck
GO
IF NOT EXISTS (SELECT * FROM sys.symmetric_keys WHERE name = '##MS_DatabaseMasterKey##')
	CREATE MASTER KEY ENCRYPTION BY password='pa$$word'
GO
CREATE ENDPOINT EP_SSB AUTHORIZATION sa
	STATE=STARTED
	AS TCP (LISTENER_PORT=1234, LISTENER_IP=ALL)
	FOR SERVICE_BROKER (AUTHENTICATION = WINDOWS)
GO
CREATE MESSAGE TYPE [tcp://codecamp/AW/sample_messagetype]
	AUTHORIZATION dbo 
	VALIDATION = NONE
GO
CREATE CONTRACT [tcp://codecamp/AW/sample_contract]
	AUTHORIZATION dbo
	(
		[tcp://codecamp/AW/sample_messagetype] SENT BY ANY
	)
GO
CREATE QUEUE [tcp://codecamp/AW/sample_sender]
	WITH STATUS=ON, 
	RETENTION=OFF
GO
CREATE QUEUE [tcp://codecamp/AW/sample_receiver]
	WITH STATUS=ON,
	RETENTION=OFF
GO
CREATE SERVICE [tcp://codecamp/AW/sample_send_service] AUTHORIZATION dbo
	ON QUEUE [tcp://codecamp/AW/sample_sender]
	([tcp://codecamp/AW/sample_contract])
GO
CREATE SERVICE [tcp://codecamp/AW/sample_receive_service] AUTHORIZATION dbo
	ON QUEUE [tcp://codecamp/AW/sample_receiver]
	([tcp://codecamp/AW/sample_contract])
GO
GRANT CONTROL ON SERVICE :: [tcp://codecamp/AW/sample_receive_service] TO PUBLIC
GO
CREATE ROUTE [tcp://codecamp/AW/route] AUTHORIZATION dbo
	WITH SERVICE_NAME = 'tcp://codecamp/AW/sample_send_service',
		BROKER_INSTANCE = '8E6701DD-698C-4EF0-951B-525BB40085A0',
	ADDRESS='TCP://SQL2K5-1:1234'	
GO
CREATE PROCEDURE usp_ReceiveMessage
AS
DECLARE @xml AS XML
DECLARE @dialog_handle as uniqueidentifier

WAITFOR ( RECEIVE TOP (1) @dialog_handle = conversation_handle, @xml = cast(message_body as xml)
	FROM [tcp://codecamp/AW/sample_receiver]), TIMEOUT 1000

IF @dialog_handle IS NULL
	return(0)

SELECT @xml

END CONVERSATION @dialog_handle
GO